<?php

/*
Plugin Name: Woocommerce Checkout Editor
Plugin URI: https://wordpressdesignfix.com/
Description: Woocommerce Checkout Editor gives users the options to add custom fields, remove existing fields, making required 
field optional on your woocommerce check out page. You can also add contentsuch as titles, images, messages anywhere on your
checkout page.
Version: 1.0
Author: Djouonang Landry
Text Domain: woocommerce-checkout-editor
Domain Path: /lang
Author URI: https://wordpressdesignfix.com/

*/

defined( 'ABSPATH' ) or die( 'Access denied buddy!' );


//Check if WooCommerce is active

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {


/**
 * Define some useful constants for shortening of path URLs
 **/
define('WOOCOMMERCE_EDITOR_VERSION', '1.0');
define('WOOCOMMERCE_EDITOR_DIR', plugin_dir_path(__FILE__));
define('WOOCOMMERCE_EDITOR_URL', plugin_dir_url(__FILE__));

function we_files_loader(){
		
    
  require_once(WOOCOMMERCE_EDITOR_DIR.'includes/backend_options.php');
   require_once(WOOCOMMERCE_EDITOR_DIR.'includes/hookfield.php');  
}
we_files_loader();
}

function woocommerce_enqueue_scripts(){
	
wp_register_script( 'bootstrap', WOOCOMMERCE_EDITOR_URL."assets/js/bootstrap.min.js", array( 'jquery' ) );
wp_register_script( 'datatables-bootstrap', WOOCOMMERCE_EDITOR_URL."assets/js/datatables.bootstrap.js", array( 'jquery' ) );
wp_register_script( 'datatables', WOOCOMMERCE_EDITOR_URL."assets/js/datatables.js", array( 'jquery' ) );
wp_register_script( 'woocommerce-checkout-editor', WOOCOMMERCE_EDITOR_URL."assets/js/woocommerce_checkout_editor.js", array( 'jquery' ) );

wp_enqueue_script('bootstrap');
wp_enqueue_script('datatables-bootstrap');
wp_enqueue_script('datatables');
wp_enqueue_script('woocommerce-checkout-editor');

 wp_localize_script( 'woocommerce-checkout-editor', 'woocommerce_checkout_object',  array( 'ajaxurl' => admin_url('admin-ajax.php')) );

}


add_action( 'admin_enqueue_scripts', 'woocommerce_enqueue_scripts' );

function woocommerce_enqueue_files(){
	
 
 wp_register_style( 'woocommerce-style-css1', WOOCOMMERCE_EDITOR_URL."assets/css/bootstrap.min.css");
 wp_register_style( 'woocommerce-style-css2', WOOCOMMERCE_EDITOR_URL."assets/css/dataTables.bootstrap.css");
 wp_register_style( 'woocommerce-style-css3', WOOCOMMERCE_EDITOR_URL."assets/css/woocommerce_checkout_co.css");


wp_enqueue_style('woocommerce-style-css1');
wp_enqueue_style('woocommerce-style-css2');
wp_enqueue_style('woocommerce-style-css3');
	
}

add_action( 'admin_enqueue_scripts', 'woocommerce_enqueue_files' );

function db_fields_function() {
 global $wpdb;

 $table_name = $wpdb->prefix . 'woocommerce_custom_fields';
 
 $charset_collate = $wpdb->get_charset_collate();
 
 $sql = "CREATE TABLE $table_name (
  id mediumint(9) NOT NULL AUTO_INCREMENT,
  name varchar(255),
  type varchar(255),
  label varchar(255),
  placeholder varchar(255),
  validation varchar(255),
  required_data varchar(255),
  enabled varchar(255),
   additional_section varchar(255),
    shipping_section varchar(255),
  billing_section varchar(255),
  html varchar(500),
  UNIQUE KEY id (id)
  ) $charset_collate;";

$result = $wpdb->query($sql); 
}
register_activation_hook(__FILE__,'db_fields_function');

