<?php

/*
Plugin Name: SlackForm Builder
Plugin URI: https://wowprezi.com/
Description: Contact form builder with feature to post form submissions to slack
Version: 1.0
Author: Djouonang Landry
Text Domain: slackform-builder
Domain Path: /lang
Author URI: https://www.wowprezi.com

*/

/**
 * Reminder
 * Jquery library will have to be updated manually as part of the plugins updates until i load jquery from wordpress inbuilt system
 **/


defined( 'ABSPATH' ) or die( 'Access denied buddy!' );

/**
 * Define some useful constants for shortening of path URLs
 **/
define('SF_SLACKFORM_VERSION', '1.0');
define('SF_SLACKFORM_DIR', plugin_dir_path(__FILE__));
define('SF_SLACKFORM_URL', plugin_dir_url(__FILE__));

/**
 * Load files
 * 
 **/
 

	  

 function sf_files_loader(){
		
    
    require_once(SF_SLACKFORM_DIR.'includes/admin_options.php');
     
}


sf_files_loader();

/**
 * Enqueue Scripts
 * 
 **/


function sf_enqueue_scriptfiles() {
	
	wp_register_script('jquery1', 'https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js', false, '3.5.1');
wp_register_script('jquery2', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js', false, '1.12.1');
 
 
wp_register_script( 'sf-popper', SF_SLACKFORM_URL."assets/js/popper.min.js", array( 'jquery' ) );
wp_register_script( 'sf-bootstrap', SF_SLACKFORM_URL."assets/js/bootstrap.min.js", array( 'jquery' ) );
wp_register_script( 'sf_form_builder', SF_SLACKFORM_URL."assets/js/sf_form_builder.js", array( 'jquery' ) );

		
	
	wp_enqueue_script('jquery1');
	wp_enqueue_script('jquery2');
	wp_enqueue_script('sf-popper');
	wp_enqueue_script('sf-bootstrap');
	wp_enqueue_script('sf_form_builder');
	



	}
	
	function frontend_enqueue_scriptfiles() {
		
		 wp_register_script( 'ajax_form_builder', SF_SLACKFORM_URL."assets/js/ajax.js", array( 'jquery' ) );
		 
		wp_enqueue_script('ajax_form_builder');
        wp_localize_script( 'ajax_form_builder', 'form_ajax_call',  array( 'ajaxurl' => admin_url('admin-ajax.php')) );
		
			}
	add_action( 'admin_enqueue_scripts', 'sf_enqueue_scriptfiles' );
	add_action( 'wp_enqueue_scripts', 'frontend_enqueue_scriptfiles' );
	
	
	

function sf_enqueue_scripts() {
 
 // wp_register_script('maskedinput',SF_SLACKFORM_URL.'/includes/js/jquery.maskedinput.min.js', array('jquery')); for later use

 wp_register_style( 'sf-css1', SF_SLACKFORM_URL."assets/css/bootstrap.min.css");
wp_register_style( 'sf-css3', SF_SLACKFORM_URL."assets/css/sf_form_builder.css");
 wp_register_style( 'sf-css2', SF_SLACKFORM_URL."assets/css/font-awesome.min.css");
 wp_register_style( 'sf-css4', SF_SLACKFORM_URL."assets/css/form_builder.min.css");


wp_enqueue_style('sf-css1');
wp_enqueue_style('sf-css3');
wp_enqueue_style('sf-css2');
wp_enqueue_style('sf-css4');

}
 
add_action( 'admin_enqueue_scripts', 'sf_enqueue_scripts' );


function db_activation_function() {
 global $wpdb;
 
 $table_name = $wpdb->prefix . 'contactform';
 
 $charset_collate = $wpdb->get_charset_collate();
 
 $sql = "CREATE TABLE $table_name (
  id mediumint(9) NOT NULL AUTO_INCREMENT,
  Name varchar(255),
  shortcode varchar(255),
  form_content varchar(500),
  email varchar(255),
  subject varchar(255),
  sender varchar(255),
   other_email varchar(255),
  message varchar(255),
  success_message varchar(500),
  error_message varchar(255),
  UNIQUE KEY id (id)
 ) $charset_collate;";
 
$result = $wpdb->query($sql); 
}
register_activation_hook(__FILE__,'db_activation_function');